/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import corgitaco.enhancedcelestials.EnhancedCelestialsWorldData;
import corgitaco.enhancedcelestials.LunarContext;
import corgitaco.enhancedcelestials.LunarEventInstance;
import corgitaco.enhancedcelestials.save.LunarEventSavedData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;

public class SetLunarEventCommand {
    public static final String EC_NOT_ENABLED = "null";

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return Commands.m_82127_((String)"setLunarEvent").then(Commands.m_82129_((String)"lunarEvent", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> {
            LunarContext lunarEventContext = ((EnhancedCelestialsWorldData)((CommandSourceStack)ctx.getSource()).m_81372_()).getLunarContext();
            return SharedSuggestionProvider.m_82981_(lunarEventContext != null ? lunarEventContext.getLunarEvents().keySet().stream() : Arrays.stream(new String[]{EC_NOT_ENABLED}), (SuggestionsBuilder)sb);
        }).executes(cs -> SetLunarEventCommand.setLunarEvent((CommandSourceStack)cs.getSource(), (String)cs.getArgument("lunarEvent", String.class))));
    }

    public static int setLunarEvent(CommandSourceStack source, String lunarEventKey) {
        List<LunarEventInstance> forecast;
        LunarEventInstance commandInstance;
        ServerLevel world = source.m_81372_();
        LunarContext lunarContext = ((EnhancedCelestialsWorldData)world).getLunarContext();
        if (lunarEventKey.equals(EC_NOT_ENABLED) || lunarContext == null) {
            source.m_81352_((Component)new TranslatableComponent("enhancedcelestials.commands.disabled"));
            return 0;
        }
        long dayLength = lunarContext.getLunarTimeSettings().getDayLength();
        long currentDay = world.m_46468_() / dayLength;
        if (lunarContext.getLunarEvents().containsKey(lunarEventKey)) {
            if (!world.m_46462_()) {
                world.m_8615_(currentDay * dayLength + 13000L);
            }
            commandInstance = new LunarEventInstance(lunarEventKey, currentDay);
            forecast = lunarContext.getLunarForecast().getForecast();
            if (!forecast.isEmpty() && forecast.get(0).active(currentDay)) {
                forecast.remove(0);
            }
        } else {
            source.m_81352_((Component)new TranslatableComponent("enhancedcelestials.commands.lunarevent_missing", new Object[]{lunarEventKey}));
            return 0;
        }
        forecast.add(0, commandInstance);
        LunarEventSavedData.get((LevelAccessor)world).setForecast(lunarContext.getLunarForecast());
        return 1;
    }
}

